//@version=4
//Full credit to AlexGrover: https://www.tradingview.com/script/fIvlS64B-G-Channels-Efficient-Calculation-Of-Upper-Lower-Extremities/
study("G-Channel Trend Detection",shorttitle="G-Trend",overlay=true)
length = input(100),src = input(close)
//----
a = 0.,b = 0.
a := max(src,nz(a[1])) - nz(a[1] - b[1])/length
b := min(src,nz(b[1])) + nz(a[1] - b[1])/length
avg = avg(a,b)
//----
crossup = b[1] < close[1] and b > close
crossdn = a[1] < close[1] and a > close
bullish = barssince(crossdn) <= barssince(crossup)
c = bullish ? color.lime : color.red
//plot(a,"Upper",color=color.blue,linewidth=2,transp=100)
//plot(b,"Lower",color=color.blue,linewidth=2,transp=100)
p1=plot(avg,"Average",color=c,linewidth=1,transp=90)
p2=plot(close,"Close price",color=c,linewidth=1,transp=100)
fill(p1,p2,color=c,transp=90)

showcross = input(true)
plotshape(showcross and not bullish and bullish[1] ? avg : na, location=location.absolute, style=shape.labeldown, color=color.red, size=size.tiny, text="Sell", textcolor=#ffffff, transp=0, offset=-1)
plotshape(showcross and bullish and not bullish[1] ? avg : na, location=location.absolute, style=shape.labelup, color=color.lime, size=size.tiny, text="Buy", textcolor=#ffffff, transp=0, offset=-1)
